;**********************************************
; Test Macnetic Card Reader 
; Hardware  : CP-PIC V4.0
; OSC	10 Mhz
; file name : macnet.asm
; Assembler : mpasm.exe
; Programmer: Watcharin Kaolop
; Company   : ETT  CO.,LTD.
; Date      : 8/8/2002
;**********************************************
; STEP to follow when test this program
;    1.Connect cable between board and Magnetic card reader
;	     
;		RC1 connect to DATA form Magnetic card reader
;		RC2 connect to CLK  form Magnetic card reader
;		RB1 connect to PRESENT form Magnetic card reader
;
;    2.Connect RS232  cable between board and PC.
;    3.Download this program to CPU.
;    4.Run terminal program such as Procom plus,XTALK etc.
;    5.Set parameter Procom plus to 9600 baud,No parity,8 bits data and 1 bit. stop
;    6.Reset board ,after reset board you will see this message on PC.
;
;                 "MAGNETIC CARD"
;       
;**********************************************

	     list p=18f458                  ; list directive to define processor
	     #include <p18f458.inc>         ; processor specific variable definitions

	
         #DEFINE SPK     PORTB,2            ; speaker on PORTB.2
	 #DEFINE DATA    PORTC,1	    ; PORTC.1 connect to PIN DATA form Magnetic Card 
	 #DEFINE CLK     PORTC,2	    ; PORTC.2 connect to PIN CLK form Magnetic Card 	
	 #DEFINE PRESENT PORTB,1	    ; PORTB.1 connect to PIN PRESENT form Magnetic Card 
	offset    EQU       0x20
	COUNT     EQU       0x21
	B1	  EQU	    0x22
	dt1       EQU       0x23
	dt2       EQU       0x24
	dt3       EQU       0x25
	DATA_IN	  EQU       0x26
	BYTE_END  EQU       0X27
	FLAG      EQU       0X28
	CHECKSUM  EQU       0X29

	          ORG       0x0000

;************ initial *******************
init        BSF       TRISC,1
	    BSF	      TRISC,2
	    BSF       TRISB,1
	    BCF       TRISB,2
            MOVLW     0X0F
	    MOVWF     BYTE_END	     ; code for stop bit

	    bcf	      INTCON2,RBPU   ; pullup PORT B	  
            movlw     0x40           ; BAUD rate 9600
            movwf     SPBRG
            clrf      TXSTA          ; 8 bits data ,no,1 stop
            bsf       RCSTA,SPEN     ; Asynchronous serial port enable
            bsf       RCSTA,CREN     ; continuous receive
            bsf       TXSTA,TXEN     ; Transmit enable
            BSF	      TXSTA,BRGH     ; HI SPEED
	  	  
;********** start to send **********************

	    call      DELAY
NEW         MOVLW     0X0C
	    CALL      SEND
	    MOVLW     "M"
	    CALL      SEND
	    MOVLW     "A"
	    CALL      SEND
	    MOVLW     "G"
	    CALL      SEND
	    MOVLW     "N"
	    CALL      SEND
	    MOVLW     "E"
	    CALL      SEND
	    MOVLW     "T"
	    CALL      SEND
	    MOVLW     "I"
	    CALL      SEND
	    MOVLW     "C"
	    CALL      SEND
	    MOVLW     " "
	    CALL      SEND
	    MOVLW     "C"
	    CALL      SEND
	    MOVLW     "A"
   	    CALL      SEND
	    MOVLW     "R"
	    CALL      SEND
	    MOVLW     "D"
	    CALL      SEND
            MOVLW     0XA
	    CALL      SEND
	    MOVLW     0XD
	    CALL      SEND   

         
START       BTFSC     PRESENT	  ; Check PRESENT 
	    GOTO      $-1	  ; wait until PRESENT = 0 
            LFSR      FSR0,0X30   ; Point to buffer address 30H in RAM
	    CLRF      FLAG	  ; FLAG = 00
	    CLRF      CHECKSUM	  ; CHECKSUM = 00 

CHK_CK	    CALL      GET_CLK     ; get clock form MAGNETIC CARD
	    BTFSC     DATA	  ; test bit data form Magnetic card
	    GOTO      CHK_CK      ; DATA = "1"
	    BSF       FLAG,0      ; DATA = "0"  START BIT = 1

GET_BYTE    MOVLW     .5	  ; counter = 5
	    MOVWF     COUNT	  
RD_DATA	    BTFSS     FLAG,0      ; check START BIT
	    CALL      GET_CLK	  ; get CLK form  MAGNETIC CARD
	    BTFSC     DATA	  ; test bit data form Magnetic card
	    GOTO      RD_1        ; Data = "1"
RD_0	    BSF       STATUS,C    ; set carry flag = "1"
	    GOTO      ROTATE
RD_1	    BCF       STATUS,C	  ; clear carry flag = "0"
ROTATE	    RRCF      DATA_IN,F   ; rotate carry flag to variable(DATA_IN)
	    DCFSNZ    COUNT,F     ; check counter skip is not zero
	    GOTO      STOP_BYTE   ; count = 00
	    BCF       FLAG,0      ; clear Flag start Bit
	    GOTO      RD_DATA     

STOP_BYTE   RRCF      DATA_IN,F	  ; Rotate to low byte 
	    RRCF      DATA_IN,F
	    RRCF      DATA_IN,F
	    
	    MOVF      DATA_IN,W   
	    ANDLW     0X0F        ; mask upper four bit 
	    MOVWF     DATA_IN     ; save to DATA_IN
            BTFSC     FLAG,1      ; STOP BIT
	    GOTO      SAVE_DATA   ; save data to RAM
	    XORWF     CHECKSUM,F  ; 

SAVE_DATA   MOVF      DATA_IN,W   
	    MOVWF     INDF0	  ; save data to address from FSR pointer
	    INCF      FSR0L       ; pointer + 1
	    BTFSC     FLAG,1      ; CHECK STOP BIT
	    GOTO      CHK_SUM     
	    MOVLW     0x0F        
	    CPFSEQ    DATA_IN     ; check byte stop
	    GOTO      GET_BYTE    ; next data
	    BSF       FLAG,1      ; STOP BIT CONDITION
	    GOTO      GET_BYTE    ; receive last byte 

CHK_SUM     MOVF      DATA_IN,W   
	    CPFSEQ    CHECKSUM    ; check sum data
	    GOTO      CHK_ERR     ; check error
	                          ; CHECKSUM  OK	  
END_CARD    BTFSS     PRESENT     ; check end card
	    GOTO      $-1         ; wait until PRESENT = "1"
	    CALL      BEEP        ; send sound to speaker 

DISPLAY     CALL      SHOW 	  ; display "DATA = "
	    LFSR      FSR0,0X30   ; point to RAM
AAA	    MOVF      INDF0,W     ; Get data to W
	    CPFSEQ    BYTE_END    ; check last byte (0x0F)
	    GOTO      NNN         ; != 0x0F
	    MOVLW     0XA
	    CALL      SEND
	    MOVLW     0XD
	    CALL      SEND
            GOTO      START	
NNN	    CALL      ADJT	  ; convert data to Ascii and display data
	    INCF      FSR0L	  ; pointer + 1 
	    GOTO      AAA     	      	  	      

;********** CHECKSUM ERROR **************
CHK_ERR     MOVLW     "C"
	    CALL      SEND
	    MOVLW     "H"
	    CALL      SEND
	    MOVLW     "K"
	    CALL      SEND
	    MOVLW     "_"
	    CALL      SEND
	    MOVLW     "E"
	    CALL      SEND
	    MOVLW     "R"
	    CALL      SEND
	    MOVLW     "R"
	    CALL      SEND
	    MOVLW     0XA
	    CALL      SEND
	    MOVLW     0XD
	    CALL      SEND	    
	    GOTO      START
	    
SHOW        MOVLW     "D"
	    CALL      SEND
	    MOVLW     "A"
	    CALL      SEND
	    MOVLW     "T"
	    CALL      SEND
	    MOVLW     "A"
	    CALL      SEND
	    MOVLW     " "
	    CALL      SEND
	    MOVLW     "="
	    CALL      SEND
	    MOVLW     " "
	    CALL      SEND
	    RETURN

;*********** GET CLK FORM MACNETIC CARD *****************

GET_CLK     BTFSC     CLK
	    GOTO      $-1	; wait until CLK = "0"
	    NOP		        __     ___
            NOP			  |___|
	    NOP
            BTFSS     CLK       ; wait until CLK = "1"
	    GOTO      $-1
	    RETURN

;**********************************************************
; Convert time 1 byte to ASCII 2 bytes and send to display
; Input  : W
; Output : -
;**********************************************************
ADJT      MOVWF     DATA_IN
	  ANDLW     0X0F
	  MOVWF     B1
	  CLRC                    ; CLEAR CARRY FLAG
	  SUBLW     0X0A
	  BZ        CC            ; = 0XA JUMP TO CC 
	  BC        CONV          ; < 0XA JUMP TO CONV
CC	  MOVF      B1,W          ; A - F
	  ADDLW     0X37
	  CALL      SEND          ; SEND FIRST DIGIT
	  RETURN
CONV      MOVF      B1,W          ; 0 - 9
          ADDLW     0X30
	  CALL      SEND	  ; SEND LAST DIGIT
          RETURN

;********* SEND DATA TO RS-232 PORT ******************

SEND	  movwf     TXREG         ; Send recent data to TX 
wait1     LFSR      FSR1,TXSTA        ; 
          btfss     INDF1,1       ; check TRMT bit in TXSTA (FSR)
          goto      wait1   
	  RETURN



;********* send sound to speaker ***********

BEEP	  MOVLW     0X7F
	  MOVWF	    dt3
pul	  bcf	    SPK      ; __   __
	  call	    DELAY    ;   |_|  |__
	  bsf	    SPK
	  call	    DELAY
	  decfsz    dt3
	  goto	    pul
	  return	 

;******** delay time **********************

DELAY     MOVLW     .2
	  MOVWF     dt1
sd2       clrf      dt2
sd1       decfsz    dt2
          goto      sd1
          decfsz    dt1
          goto      sd2
          return

  END
